/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import icyllis.annotations.ApiStatus;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.forge.ModernUIForge;
import icyllis.modernui.core.forge.ServerHandler;
import icyllis.modernui.graphics.BlurHandler;
import icyllis.modernui.graphics.font.GlyphManager;
import icyllis.modernui.graphics.textmc.ModernFontRenderer;
import icyllis.modernui.graphics.textmc.TextLayoutProcessor;
import icyllis.modernui.test.TestHUD;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;

@ApiStatus.Internal
public final class Config {
    static final Client CLIENT;
    private static final ForgeConfigSpec CLIENT_SPEC;
    static final Common COMMON;
    private static final ForgeConfigSpec COMMON_SPEC;
    static final Server SERVER;
    private static final ForgeConfigSpec SERVER_SPEC;

    static void init() {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("ModernUI"), (String)"ModernUI");
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        if (FMLEnvironment.dist.isClient()) {
            mod.addConfig((ModConfig)new Cfg(ModConfig.Type.CLIENT, CLIENT_SPEC, mod, "client"));
            mod.addConfig((ModConfig)new Cfg(ModConfig.Type.COMMON, COMMON_SPEC, mod, "common"));
            mod.addConfig((ModConfig)new Cfg(ModConfig.Type.SERVER, SERVER_SPEC, mod, "server"));
        } else {
            mod.addConfig((ModConfig)new Cfg(ModConfig.Type.COMMON, COMMON_SPEC, mod, "server"));
            mod.addConfig((ModConfig)new Cfg(ModConfig.Type.SERVER, SERVER_SPEC, mod, "shared"));
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Config::reload);
    }

    static void reload(@Nonnull ModConfig.ModConfigEvent event) {
        ForgeConfigSpec spec = event.getConfig().getSpec();
        if (spec == CLIENT_SPEC) {
            Config.CLIENT.reload();
            ModernUI.LOGGER.debug(ModernUI.MARKER, "Client config reloaded");
        } else if (spec == COMMON_SPEC) {
            Config.COMMON.reload();
            ModernUI.LOGGER.debug(ModernUI.MARKER, "Common config reloaded");
        } else if (spec == SERVER_SPEC) {
            Config.SERVER.reload();
            ModernUI.LOGGER.debug(ModernUI.MARKER, "Server config reloaded");
        }
    }

    static {
        ForgeConfigSpec.Builder builder;
        if (FMLEnvironment.dist.isClient()) {
            builder = new ForgeConfigSpec.Builder();
            CLIENT = new Client(builder);
            CLIENT_SPEC = builder.build();
        } else {
            CLIENT = null;
            CLIENT_SPEC = null;
        }
        builder = new ForgeConfigSpec.Builder();
        COMMON = new Common(builder);
        COMMON_SPEC = builder.build();
        builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_SPEC = builder.build();
    }

    public static class Server {
        private Server(@Nonnull ForgeConfigSpec.Builder builder) {
        }

        private void reload() {
        }
    }

    public static class Common {
        private final ForgeConfigSpec.BooleanValue developerMode;
        final ForgeConfigSpec.IntValue oneTimeEvents;
        final ForgeConfigSpec.BooleanValue autoShutdown;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> shutdownTimes;

        private Common(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.comment("Developer Config").push("developer");
            this.developerMode = builder.comment("Whether to enable developer mode.").define("enableDeveloperMode", false);
            this.oneTimeEvents = builder.defineInRange("oneTimeEvents", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Auto Shutdown Config").push("autoShutdown");
            this.autoShutdown = builder.comment("Enable auto-shutdown for server.").define("enable", false);
            this.shutdownTimes = builder.comment("The time points of when server will auto-shutdown. Format: HH:mm.").defineList("times", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("04:00");
                list.add("16:00");
                return list;
            }, s2 -> true);
            builder.pop();
        }

        private void reload() {
            ModernUIForge.developerMode = (Boolean)this.developerMode.get();
            ServerHandler.INSTANCE.determineShutdownTime();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private final ForgeConfigSpec.BooleanValue blurEffect;
        private final ForgeConfigSpec.IntValue animationDuration;
        private final ForgeConfigSpec.IntValue blurRadius;
        private final ForgeConfigSpec.DoubleValue backgroundAlpha;
        private final ForgeConfigSpec.BooleanValue tooltip;
        private final ForgeConfigSpec.ConfigValue<String> tooltipColor;
        private final ForgeConfigSpec.BooleanValue ding;
        private final ForgeConfigSpec.BooleanValue hudBars;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> blurBlacklist;
        private final ForgeConfigSpec.ConfigValue<String> preferredFont;
        final ForgeConfigSpec.BooleanValue globalRenderer;
        final ForgeConfigSpec.BooleanValue allowShadow;
        private final ForgeConfigSpec.BooleanValue antiAliasing;
        private final ForgeConfigSpec.BooleanValue highPrecision;
        private final ForgeConfigSpec.BooleanValue enableMipmap;
        private final ForgeConfigSpec.IntValue mipmapLevel;
        private final ForgeConfigSpec.IntValue defaultFontSize;

        private Client(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.comment("Screen Config").push("screen");
            this.animationDuration = builder.comment("The duration of screen background and blur radius animation in milliseconds. (0 = OFF)").defineInRange("animationDuration", 200, 0, 800);
            this.backgroundAlpha = builder.comment("Screen black background opacity in game, higher values will get darker.").defineInRange("backgroundAlpha", 0.4, 0.0, 0.8);
            this.blurEffect = builder.comment("Add blur effect to world renderer when opened, it is incompatible with OptiFine's FXAA shader or some mods.").define("blurEffect", true);
            this.blurRadius = builder.comment("The blur effect radius, higher values result in a small loss of performance.").defineInRange("blurRadius", 10, 2, 18);
            this.blurBlacklist = builder.comment("A list of GUI screen superclasses that won't activate blur effect when opened.").defineList("blurBlacklist", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add(ChatScreen.class.getName());
                return list;
            }, s2 -> true);
            builder.pop();
            builder.comment("Tooltip Config").push("tooltip");
            this.tooltip = builder.comment("Enable Modern UI's tooltip style.").define("enable", true);
            this.tooltipColor = builder.comment("The tooltip frame color. Format: 0xRRGGBB. Default value: 0xAADCF0").define("frameColor", (Object)"0xAADCF0");
            builder.pop();
            builder.comment("General Config").push("general");
            this.ding = builder.comment("Play a sound effect when the game is loaded.").define("ding", true);
            this.hudBars = builder.comment("Show additional HUD bars added by ModernUI on the bottom-left of the screen.").define("hudBars", false);
            builder.pop();
            builder.comment("Font Engine Config").push("font");
            this.globalRenderer = builder.comment("Apply Modern UI font renderer (including text layouts) to the entire game rather than only Modern UI itself.").define("globalRenderer", true);
            this.preferredFont = builder.comment(new String[]{"The font with the highest priority to use, the built-in font is always the second choice.", "This can be font family name if you want to use fonts that installed on your PC, for instance: Microsoft YaHei", "Or can be file path if you want to use external fonts, for instance: D:/Fonts/biliw.otf", "Or can be resource location if you want to use fonts in resource packs, for instance: modernui:font/biliw.otf"}).define("preferredFont", (Object)"");
            this.allowShadow = builder.comment("Allow global font renderer to draw text with shadow, setting to false can improve performance.").define("allowShadow", true);
            this.antiAliasing = builder.comment("Enable font anti-aliasing.").define("antiAliasing", true);
            this.highPrecision = builder.comment("Enable high precision rendering, this is very useful especially when the font is very small.").define("highPrecision", true);
            this.enableMipmap = builder.comment("Enable mipmap for font textures, this makes font will not be blurred when scaling down.").define("enableMipmap", true);
            this.mipmapLevel = builder.comment("The mipmap level for font textures.").defineInRange("mipmapLevel", 4, 0, 4);
            this.defaultFontSize = builder.comment("The default font size for texts with no size specified. (deprecated, to be removed)").defineInRange("defaultFontSize", 16, 12, 20);
            builder.pop();
        }

        private void reload() {
            BlurHandler.sBlurEffect = (Boolean)this.blurEffect.get();
            BlurHandler.sAnimationDuration = ((Integer)this.animationDuration.get()).intValue();
            BlurHandler.sBlurRadius = ((Integer)this.blurRadius.get()).intValue();
            BlurHandler.sBackgroundAlpha = ((Double)this.backgroundAlpha.get()).floatValue();
            BlurHandler.INSTANCE.loadBlacklist((List)this.blurBlacklist.get());
            TestHUD.sTooltip = (Boolean)this.tooltip.get();
            String tooltipColor = (String)this.tooltipColor.get();
            try {
                int i = Integer.valueOf(tooltipColor.substring(2), 16);
                TestHUD.sTooltipR = i >> 16 & 0xFF;
                TestHUD.sTooltipG = i >> 8 & 0xFF;
                TestHUD.sTooltipB = i & 0xFF;
            }
            catch (NumberFormatException e) {
                ModernUI.LOGGER.error(ModernUI.MARKER, "Wrong color format for setting tooltip color: {}", (Object)tooltipColor, (Object)e);
            }
            TestHUD.sDing = (Boolean)this.ding.get();
            TestHUD.sBars = (Boolean)this.hudBars.get();
            Minecraft.func_71410_x().func_222817_e(() -> ModernFontRenderer.change((Boolean)this.globalRenderer.get(), (Boolean)this.allowShadow.get()));
            GlyphManager.sPreferredFont = (String)this.preferredFont.get();
            GlyphManager.sAntiAliasing = (Boolean)this.antiAliasing.get();
            GlyphManager.sHighPrecision = (Boolean)this.highPrecision.get();
            GlyphManager.sEnableMipmap = (Boolean)this.enableMipmap.get();
            GlyphManager.sMipmapLevel = (Integer)this.mipmapLevel.get();
            TextLayoutProcessor.sDefaultFontSize = (Integer)this.defaultFontSize.get();
        }
    }

    private static class Toml
    extends ConfigFileTypeHandler {
        private Toml() {
        }

        private static Path reroute(@Nonnull Path configBasePath) {
            if (configBasePath.endsWith("serverconfig")) {
                return FMLPaths.CONFIGDIR.get();
            }
            return configBasePath;
        }

        public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
            return super.reader(Toml.reroute(configBasePath));
        }

        public void unload(Path configBasePath, ModConfig config) {
            super.unload(Toml.reroute(configBasePath), config);
        }
    }

    private static class Cfg
    extends ModConfig {
        private static final Toml _TOML = new Toml();

        public Cfg(ModConfig.Type type, ForgeConfigSpec spec, ModContainer container, String name) {
            super(type, spec, container, "ModernUI/" + name + ".toml");
        }

        public ConfigFileTypeHandler getHandler() {
            return _TOML;
        }
    }
}

